/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.portal;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.block.portal.AetherPortalForcer;
import com.aetherteam.aether.block.portal.AetherPortalShape;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.client.sound.FadeOutSoundInstance;
import com.aetherteam.aether.world.LevelUtil;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4048;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import net.minecraft.class_5819;
import net.minecraft.class_9797;
import org.jetbrains.annotations.Nullable;

public class AetherPortalBlock
extends class_2248
implements class_9797 {
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    protected static final class_265 X_AXIS_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final class_265 Z_AXIS_AABB = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public AetherPortalBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS});
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (entity.method_5822(false)) {
            entity.method_60697((class_9797)this, pos);
        }
    }

    public int method_60772(class_3218 pLevel, class_1297 pEntity) {
        return this.getLevelPortalTransitionTime((class_1937)pLevel, pEntity);
    }

    private int getLevelPortalTransitionTime(class_1937 level, class_1297 entity) {
        int n;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            n = Math.max(1, level.method_8450().method_8356(player.method_31549().field_7480 ? class_1928.field_46795 : class_1928.field_46794));
        } else {
            n = 0;
        }
        return n;
    }

    @Nullable
    public class_5454 method_60770(class_3218 level, class_1297 entity, class_2338 pos) {
        class_5321<class_1937> resourcekey = entity.method_37908().method_27983() == LevelUtil.destinationDimension() ? LevelUtil.returnDimension() : LevelUtil.destinationDimension();
        class_3218 serverlevel = level.method_8503().method_3847(resourcekey);
        if (serverlevel == null) {
            return null;
        }
        class_2784 worldborder = serverlevel.method_8621();
        double d0 = class_2874.method_31109((class_2874)level.method_8597(), (class_2874)serverlevel.method_8597());
        class_2338 blockpos = worldborder.method_39538(entity.method_23317() * d0, entity.method_23318(), entity.method_23321() * d0);
        return this.getExitPortal(serverlevel, entity, pos, blockpos, worldborder);
    }

    @Nullable
    private class_5454 getExitPortal(class_3218 pLevel, class_1297 pEntity, class_2338 pPos, class_2338 pExitPos, class_2784 pWorldBorder) {
        class_5454.class_9823 dimensiontransition$postdimensiontransition;
        class_5459.class_5460 blockutil$foundrectangle;
        AetherPortalForcer portalForcer = new AetherPortalForcer(pLevel);
        Optional<class_2338> optional = portalForcer.findClosestPortalPosition(pExitPos, pWorldBorder);
        if (optional.isPresent()) {
            class_2338 blockpos = optional.get();
            class_2680 blockstate = pLevel.method_8320(blockpos);
            blockutil$foundrectangle = class_5459.method_30574((class_2338)blockpos, (class_2350.class_2351)((class_2350.class_2351)blockstate.method_11654((class_2769)class_2741.field_12529)), (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, p_351970_ -> pLevel.method_8320(p_351970_) == blockstate);
            dimensiontransition$postdimensiontransition = AetherPortalForcer.PLAY_PORTAL_SOUND.then(p_351967_ -> p_351967_.method_60950(blockpos));
        } else {
            class_2350.class_2351 direction$axis = pEntity.method_37908().method_8320(pPos).method_28500(AXIS).orElse(class_2350.class_2351.field_11048);
            Optional<class_5459.class_5460> optional1 = portalForcer.createPortal(pExitPos, direction$axis);
            if (optional1.isEmpty()) {
                Aether.LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            blockutil$foundrectangle = optional1.get();
            dimensiontransition$postdimensiontransition = AetherPortalForcer.PLAY_PORTAL_SOUND.then(class_5454.field_52247);
        }
        return AetherPortalBlock.getDimensionTransitionFromExit(pEntity, pPos, blockutil$foundrectangle, pLevel, dimensiontransition$postdimensiontransition);
    }

    private static class_5454 getDimensionTransitionFromExit(class_1297 pEntity, class_2338 pPos, class_5459.class_5460 pRectangle, class_3218 pLevel, class_5454.class_9823 pPostDimensionTransition) {
        class_243 vec3;
        class_2350.class_2351 direction$axis;
        class_2680 blockstate = pEntity.method_37908().method_8320(pPos);
        if (blockstate.method_28498((class_2769)class_2741.field_12529)) {
            direction$axis = (class_2350.class_2351)blockstate.method_11654((class_2769)class_2741.field_12529);
            class_5459.class_5460 blockutil$foundrectangle = class_5459.method_30574((class_2338)pPos, (class_2350.class_2351)direction$axis, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, p_351016_ -> pEntity.method_37908().method_8320(p_351016_) == blockstate);
            vec3 = pEntity.method_30633(direction$axis, blockutil$foundrectangle);
        } else {
            direction$axis = class_2350.class_2351.field_11048;
            vec3 = new class_243(0.5, 0.0, 0.0);
        }
        return AetherPortalBlock.createDimensionTransition(pLevel, pRectangle, direction$axis, vec3, pEntity, pEntity.method_18798(), pEntity.method_36454(), pEntity.method_36455(), pPostDimensionTransition);
    }

    private static class_5454 createDimensionTransition(class_3218 pLevel, class_5459.class_5460 pRectangle, class_2350.class_2351 pAxis, class_243 pOffset, class_1297 pEntity, class_243 pSpeed, float pYRot, float pXRot, class_5454.class_9823 pPostDimensionTransition) {
        class_2338 blockpos = pRectangle.field_25936;
        class_2680 blockstate = pLevel.method_8320(blockpos);
        class_2350.class_2351 direction$axis = blockstate.method_28500((class_2769)class_2741.field_12529).orElse(class_2350.class_2351.field_11048);
        double d0 = pRectangle.field_25937;
        double d1 = pRectangle.field_25938;
        class_4048 entitydimensions = pEntity.method_18377(pEntity.method_18376());
        int i = pAxis == direction$axis ? 0 : 90;
        class_243 vec3 = pAxis == direction$axis ? pSpeed : new class_243(pSpeed.field_1350, pSpeed.field_1351, -pSpeed.field_1352);
        double d2 = (double)entitydimensions.comp_2185() / 2.0 + (d0 - (double)entitydimensions.comp_2185()) * pOffset.method_10216();
        double d3 = (d1 - (double)entitydimensions.comp_2186()) * pOffset.method_10214();
        double d4 = 0.5 + pOffset.method_10215();
        boolean flag = direction$axis == class_2350.class_2351.field_11048;
        class_243 vec31 = new class_243((double)blockpos.method_10263() + (flag ? d2 : d4), (double)blockpos.method_10264() + d3, (double)blockpos.method_10260() + (flag ? d4 : d2));
        class_243 vec32 = AetherPortalShape.findCollisionFreePosition(vec31, pLevel, pEntity, entitydimensions);
        return new class_5454(pLevel, vec32, vec3, pYRot + (float)i, pXRot, pPostDimensionTransition);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (random.method_43048(100) == 0) {
            class_310.method_1551().method_1483().method_4873((class_1113)new FadeOutSoundInstance(AetherSoundEvents.BLOCK_AETHER_PORTAL_AMBIENT.get(), class_3419.field_15245, 0.5f, random.method_43057() * 0.4f + 0.8f, class_5819.method_43049((long)random.method_43055()), false, 0, class_1113.class_1114.field_5476, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, false));
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.method_10263() + random.method_43058();
            double y = (double)pos.method_10264() + random.method_43058();
            double z = (double)pos.method_10260() + random.method_43058();
            double xSpeed = ((double)random.method_43057() - 0.5) * 0.5;
            double ySpeed = ((double)random.method_43057() - 0.5) * 0.5;
            double zSpeed = ((double)random.method_43057() - 0.5) * 0.5;
            int j = random.method_43048(2) * 2 - 1;
            if (!level.method_8320(pos.method_10067()).method_27852((class_2248)this) && !level.method_8320(pos.method_10078()).method_27852((class_2248)this)) {
                x = (double)pos.method_10263() + 0.5 + 0.25 * (double)j;
                xSpeed = random.method_43057() * 2.0f * (float)j;
            } else {
                z = (double)pos.method_10260() + 0.5 + 0.25 * (double)j;
                zSpeed = random.method_43057() * 2.0f * (float)j;
            }
            level.method_8406((class_2394)AetherParticleTypes.AETHER_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11465, class_2470.field_11463 -> {
                switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                    case field_11051: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
                    }
                    case field_11048: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        if (state.method_11654(AXIS) == class_2350.class_2351.field_11051) {
            return Z_AXIS_AABB;
        }
        return X_AXIS_AABB;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        class_2350.class_2351 directionAxis = direction.method_10166();
        class_2350.class_2351 blockAxis = (class_2350.class_2351)state.method_11654(AXIS);
        boolean flag = blockAxis != directionAxis && directionAxis.method_10179();
        return !flag && !facingState.method_27852((class_2248)this) && !new AetherPortalShape(level, currentPos, blockAxis).isComplete() ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, facingState, level, currentPos, facingPos);
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        return class_1799.field_8037;
    }
}

